<?php
require_once "conexion.php";
class ModeloCaja {

    //resibir parametros como fechaActual, valorApertura, idUsuario, estadoCierre
    static public function mdlIngresarAperturaCaja($tabla, $datos){
        $con = Conexion::conectar();
        $stmt = $con->prepare("INSERT INTO $tabla(fechaRegistro, aperturaCaja, idUsuario, estadoCierre) VALUES (:fechaRegistro, :aperturaCaja, :idUsuario, :estadoCierre)");


		$stmt->bindParam(":fechaRegistro", $datos["fechaActual"], PDO::PARAM_STR);
        $stmt->bindParam(":aperturaCaja", $datos["valorApertura"], PDO::PARAM_INT);
        $stmt->bindParam(":idUsuario", $datos["idUsuario"], PDO::PARAM_INT);
        $stmt->bindParam(":estadoCierre", $datos["estadoCierre"], PDO::PARAM_STR);

		if($stmt->execute()){
            $idd = $con->lastInsertId();
            /*
            echo `<script>swal({
                type: "success",
                title: "¡Caja Iniciada con exito!",
                showConfirmButton: true,
                confirmButtonText: "Cerrar"
                }).then(function(result){
                if (result.value) {
                  //window.location = "personas";
                  $('#idCaja').val(response.respuesta);
                }
              })</script>`;
*/
			return $idd;

		}else{

			return "errorr";

		}

		$stmt = null;
    }

    // validar si la caja ya fue abierta
    static public function mdlValidarAperturaModal($tabla, $datos){
        //SELECT id, fechaRegistro, idUsuario from caja WHERE idUsuario = 1 and fechaRegistro = '2021-02-09'
        $stmt = Conexion::conectar()->prepare("SELECT id, fechaRegistro, fechaCierre, idUsuario, estadoCierre from $tabla WHERE idUsuario = :idUsuario and (fechaCierre = :fechaCierre or estadoCierre = 'Apertura')");

        $stmt->bindParam(":idUsuario", $datos["idUsuario"], PDO::PARAM_INT);
		$stmt->bindParam(":fechaCierre", $datos["fechaCierre"], PDO::PARAM_STR);

		if($stmt->execute()){
            return  $stmt->fetchAll();
            //return $stmt -> fetch();
		}else{

			return "errorr";

		}

		$stmt = null;
    }

     // validar si la caja ya fue abierta
     static public function mdlValidarApertura($tabla, $datos){
        //SELECT id, fechaRegistro, idUsuario from caja WHERE idUsuario = 1 and fechaRegistro = '2021-02-09'
        $stmt = Conexion::conectar()->prepare("SELECT id, fechaRegistro, fechaCierre, idUsuario, estadoCierre from $tabla WHERE idUsuario = :idUsuario ");

        $stmt->bindParam(":idUsuario", $datos["idUsuario"], PDO::PARAM_INT);
		//$stmt->bindParam(":fechaCierre", $datos["fechaCierre"], PDO::PARAM_STR);

		if($stmt->execute()){
            return  $stmt->fetchAll();
            //return $stmt -> fetch();
		}else{

			return "errorr";

		}

		$stmt = null;
    }


    // cerrar caja
    static public function mdlCerrarCaja($tabla, $datos){
        $stmt = Conexion::conectar()->prepare("UPDATE $tabla SET totalIngreso = :totalIngreso, totalEntregado = :totalEntregado, saldoSigiente = :saldoSigiente, totalComercial = :totalComercial, totalDomiciliario = :totalDomiciliario, estadoCierre = :estadoCierre, fechaCierre = :fechaCierre WHERE id = :id");

		$stmt -> bindParam(":totalIngreso", $datos['totalIngreso'], PDO::PARAM_STR);
        $stmt -> bindParam(":totalEntregado", $datos['totalEntregado'], PDO::PARAM_STR);
        $stmt -> bindParam(":saldoSigiente", $datos['saldoSigiente'], PDO::PARAM_STR);
        $stmt -> bindParam(":totalComercial", $datos['totalComercial'], PDO::PARAM_STR);
        $stmt -> bindParam(":totalDomiciliario", $datos['totalDomiciliario'], PDO::PARAM_INT);
        $stmt -> bindParam(":estadoCierre", $datos['estadoCierre'], PDO::PARAM_STR);
        $stmt -> bindParam(":fechaCierre", $datos['fechaCierre'], PDO::PARAM_STR);
        $stmt -> bindParam(":id", $datos['id'], PDO::PARAM_INT);

		if($stmt->execute()){

			return "ok";

		}else{

			return "error";

		}

		$stmt = null;
    }

    static public function mdlConsultarSaldoAnterior($fecha, $idUsuario){
    //SELECT saldoSigiente FROM caja WHERE fechaRegistro = "2021-02-24" && idUsuario = 1
        //$stmt = Conexion::conectar()->prepare("SELECT saldoSigiente FROM caja WHERE fechaRegistro = :fechaRegistro && idUsuario = :idUsuario");
        $stmt = Conexion::conectar()->prepare("SELECT saldoSigiente FROM caja WHERE idUsuario = :idUsuario ORDER BY id DESC");
        //$stmt = Conexion::conectar()->prepare("SELECT saldoSigiente FROM caja WHERE fechaRegistro = '2021-02-24' && idUsuario = 1");

            //$stmt -> bindParam(":fechaRegistro", $fecha, PDO::PARAM_STR);
            $stmt -> bindParam(":idUsuario", $idUsuario, PDO::PARAM_INT);

			$stmt -> execute();

			return $stmt -> fetchColumn();




		$stmt = null;
    }

    //consulta caja por id
    static public function mdlConsultarCaja($tabla, $item, $valor, $fecha1 = null, $fecha2 = null){
        //SELECT sum(importeCaja) as totalDomiciliario FROM detalleCaja WHERE concepto = "Comercial" and idCaja = 19
        //SELECT * FROM tablaCaja WHERE id = 19 and estadoCierre = "Cerrado"
        if($item != null){
            $sqlBase = "SELECT * FROM $tabla WHERE $item = :$item and ";
        } else {
            $sqlBase = "SELECT * FROM $tabla WHERE ";
        }
        
        if( ($fecha1 != null && $fecha1 != "") && ($fecha2 != null && $fecha2 != "") ){
            $stmt = Conexion::conectar()->prepare("$sqlBase estadoCierre = :estadoCierre and  fechaRegistro BETWEEN :fecha1 and :fecha2");
            $stmt -> bindParam(":estadoCierre", $valor[1], PDO::PARAM_INT);
            $stmt -> bindParam(":fecha1", $fecha1, PDO::PARAM_STR);
            $stmt -> bindParam(":fecha2", $fecha2, PDO::PARAM_STR);

        } else if($fecha1 != null && $fecha1 != ""){
            $stmt = Conexion::conectar()->prepare("$sqlBase estadoCierre = :estadoCierre and fechaRegistro = :fecha1");
            $stmt -> bindParam(":estadoCierre", $valor[1], PDO::PARAM_INT);
            $stmt -> bindParam(":fecha1", $fecha1, PDO::PARAM_STR);

        } else if($fecha2 != null && $fecha2 != ""){
            $stmt = Conexion::conectar()->prepare("$sqlBase estadoCierre = :estadoCierre and fechaRegistro = :fecha2");  
            $stmt -> bindParam(":estadoCierre", $valor[1], PDO::PARAM_INT);
            $stmt -> bindParam(":fecha2", $fecha2, PDO::PARAM_STR);
        }else {
            $stmt = Conexion::conectar()->prepare("$sqlBase  estadoCierre = :estadoCierre");
            $stmt -> bindParam(":estadoCierre", $valor[1], PDO::PARAM_INT);

        }


        if($item != null){
            $stmt -> bindParam(":".$item, $valor[0], PDO::PARAM_INT);
        }
        
			$stmt -> execute();

			return $stmt -> fetchAll();




		$stmt = null;
    }

    // consultar total de importe segun concepto
    static public function mdlImporteSegunConcepto($concepto, $idCaja){
        if($concepto == "Domiciliario")
            $concepto = "Domiciliar";

        $stmt = Conexion::conectar()->prepare("SELECT sum(importeCaja) as totalImporte FROM detallecaja WHERE tipoCaja = :concepto and idCaja = :idCaja");

        $stmt -> bindParam(":concepto", $concepto, PDO::PARAM_STR);
        $stmt -> bindParam(":idCaja", $idCaja, PDO::PARAM_INT);

        $stmt -> execute();

        return $stmt -> fetchColumn();




    $stmt = null;
    }


    // consultar el detalle de la caja
    static public function mdlConsultarDetalleCaja($tabla, $idCaja){
        $sql = "SELECT det.id, idCaja, fechaRegistro, tipoCaja, concepto, numeroDocumento, importeCaja, tipoPago, generadoPor, nombre, documento from $tabla as det inner join usuarios as usu on usu.id = det.generadoPor where idCaja = :idCaja";
        //"SELECT id, fechaRegistro, tipoCaja, concepto, numeroDocumento, tipoPago, importeCaja, estadoCaja from $tabla where idCaja = :idCaja"
        $stmt = Conexion::conectar()->prepare($sql);

        $stmt -> bindParam(":idCaja", $idCaja, PDO::PARAM_INT);
        $stmt -> execute();

        return $stmt -> fetchAll();

        $stmt = null;
    }

    // consultar el detalle de la caja
    static public function mdlConsultarDetalleCajaMovimiento($tabla, $idCaja = null, $fecha1 = null, $fecha2 = null){

        if($idCaja != null){
            //$sql = "SELECT * from $tabla WHERE idCaja in ($idCaja)";
            $sql = "SELECT det.id, idCaja, fechaRegistro, tipoCaja, concepto, numeroDocumento, importeCaja, tipoPago, generadoPor, nombre, documento from detallecaja as det inner join usuarios as usu on usu.id = det.generadoPor where idCaja in ($idCaja)";
            if($fecha1 != null && $fecha2 != null)
                $sql .= " and  fechaRegistro BETWEEN \"".$fecha1."\" and \"".$fecha2."\"";
            elseif($fecha1 != null)
                $sql .= " and  fechaRegistro = \"".$fecha1."\"";
            elseif($fecha2 != null)
                $sql .= " and  fechaRegistro = \"".$fecha2."\"";
        } else {
            //$sql = "SELECT * from $tabla ";
            $sql = "SELECT det.id, idCaja, fechaRegistro, tipoCaja, concepto, numeroDocumento, importeCaja, tipoPago, generadoPor, nombre, documento from detallecaja as det inner join usuarios as usu on usu.id = det.generadoPor ";
            if($fecha1 != null && $fecha2 != null)
                $sql .= " WHERE  fechaRegistro BETWEEN \"".$fecha1."\" and \"".$fecha2."\"";
            elseif($fecha1 != null)
                $sql .= " WHERE  fechaRegistro = \"".$fecha1."\"";
            elseif($fecha2 != null)
                $sql .= " WHERE  fechaRegistro = \"".$fecha2."\"";
        }
         
        $stmt = Conexion::conectar()->prepare($sql);
        $stmt -> execute();

        return $stmt -> fetchAll();

        $stmt = null;
    }

     // consultar el detalle de la caja
     static public function mdlConsultarCajaUsuario($tabla, $idUsuario){
        $stmt = Conexion::conectar()->prepare("SELECT id from $tabla where idUsuario = $idUsuario");
        $stmt -> execute();
        return $stmt -> fetchAll();
        $stmt = null;
    }

}
